# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 5
# Experiment: PMxPM, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR5_strategy.txt
# LLM Suggested Fallback: C

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR5(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:
        return "C"
    
    # Check if opponent always defects or cooperates
    always_c = "return 'C'" in opponent_program_code or "return 'c'" in opponent_program_code
    always_d = "return 'D'" in opponent_program_code or "return 'd'" in opponent_program_code
    
    if always_d:
        return "D"
    if always_c:
        if len(my_history) % 3 == 0:
            return "D"
        else:
            return "C"
    
    # Tit-for-Tat with Forgiveness
    if opp_history[-1] == "D":
        return "D"
    elif opp_history[-1] == "C" and my_history[-1] == "D":
        return "C"
    
    # Late-Game Adjustment
    if len(my_history) >= 8 and opp_history.count("D") > 2:
        return "D"
    
    return "C"